function [train] = linNeuron(input)

%create a linear filter in 10 msec bins that spans 20 time steps into the past
%
% Comments:
% -this method takes in an input which is used to drive an inhomogeneous Poisson process with rate
%   r = b + (w conv x), the spike train of which is returned (1 sec, in 10ms bins)
% -it uses a biphasic 20 tap linear filter in 10ms bins
% -note that the b term is built into the code (as a constant, which can be altered if you wish) 
%   in an attempt to avoid negative firing rates (in later parts of the question, you can look 
%   into estimating b as part of the linear regression)

mu1=18; 
mu2=12; 
sigma1=1;
sigma2=5;

x=1:20;
gauss1=exp(-(x-mu1).^2/2/sigma1^2);
gauss2=0.2*exp(-(x-mu2).^2/2/sigma2^2);
k=gauss1-gauss2;
k=k./norm(k); %normalize K

%convolve linear filter with input
linOut=conv(input,fliplr(k));
linOut(length(linOut)-18:length(linOut))=[];

baseline=1;
instRate=baseline+linOut;

train=poissrnd(instRate);