function [train] = lnpNeuron2(input)


%create a linear filter in 10 msec bins that spans 20 time steps into the
%past

mu1=18; 
mu2=12; 
sigma1=1;
sigma2=5;

x=1:20;
gauss1=exp(-(x-mu1).^2/2/sigma1^2);
gauss2=0.2*exp(-(x-mu2).^2/2/sigma2^2);
k=gauss1-gauss2;
k=k./norm(k); %normalize K

%convolve linear filter with input
linOut=conv(input,fliplr(k));
linOut(length(linOut)-18:length(linOut))=[];

instRate=linOut.^2;

train=poissrnd(instRate);
train(isnan(train)) = 0;
